﻿
'Copyright 2019 item Industrietechnik GmbH [http: //www.item24.com]

'This license Is For the sample source code only:
'----------------------------------------------------------------------------
'   Licensed under the Apache License, Version 2.0 (the "License");
'   you may Not use this file except In compliance With the License.
'   You may obtain a copy Of the License at

'     http://www.apache.org/licenses/LICENSE-2.0

'   Unless required by applicable law Or agreed To In writing, software
'   distributed under the License Is distributed On an "AS IS" BASIS,
'   WITHOUT WARRANTIES Or CONDITIONS Of ANY KIND, either express Or implied.
'   See the License For the specific language governing permissions And
'   limitations under the License.
'----------------------------------------------------------------------------

'The compiled libraries that come With this sample have their own license
'attached to them. Make sure you understand those licenses.

'ObjectService can ONLY be legally used together With item ILMU hardware And
'ONLY for the creation of software used to control Or analyze purchased item
'hardware.It may Not under any circumstances be transmitted to other companies
'Or entities unless prior permission was granted by item Industrietechnik GmbH.

Imports System
Imports System.Collections.Generic
Imports System.Diagnostics
Imports System.Windows
Imports System.Windows.Media

'///////////////////////////////////////////////////////////////////////////////////////////////
'// WARNING - WARNING - WARNING - WARNING - WARNING - WARNING - WARNING - WARNING - WARNING - 
'///////////////////////////////////////////////////////////////////////////////////////////////
'// DO Not use this software on an unparametrized ILMU, because it may be destroyed
'// Make sure the ILMU Is ready to be moved And that the machine Is SAFE
'// Use the MotionSoft setup routine if you are Not sure!
'//
'// To write into ObjectService registers, you can use the following code:
'// Controller.WriteComObject(Item.Ilmu.ObjectService.ComObjectType.BETRIEBSART, (int)Item.Ilmu.ObjectService.BetriebsArt.Positioning);
'//
'// DO Not WRITE INTO ANY CONTROLLER REGISTERS IF YOU ARE Not 100% SURE WHAT THEY DO!
'// Writing incorrect data into the registers will destroy the ILMU hardware if you try to move
'///////////////////////////////////////////////////////////////////////////////////////////////
'// WARNING - WARNING - WARNING - WARNING - WARNING - WARNING - WARNING - WARNING - WARNING - 
'///////////////////////////////////////////////////////////////////////////////////////////////

Namespace VisualBasic_MoveSample
    Partial Public Class MainWindow
        Inherits Window

        Private Controller As Item.Ilmu.ObjectService.ObjectService
        Private LastStatusWord As UInteger = 0

        Public Sub New()
            InitializeComponent()
            Controller = New Item.Ilmu.ObjectService.ObjectService(Item.Ilmu.ObjectService.ObjectServiceMode.OnlyMovement_ReadWrite, Item.Ilmu.ObjectService.LoggingMode.Debug Or Item.Ilmu.ObjectService.LoggingMode.Info Or Item.Ilmu.ObjectService.LoggingMode.Success Or Item.Ilmu.ObjectService.LoggingMode.Warn, False)

            AddHandler Controller.Connected, AddressOf Controller_Connected
            AddHandler Controller.Disconnected, AddressOf Controller_Disconnected
            AddHandler Controller.LogMessage, AddressOf Controller_LogMessage
            AddHandler Controller.MovementStatusChanged, AddressOf Controller_MovementStatusChanged
            AddHandler Controller.RegisterChanged, AddressOf Controller_RegisterChanged
            AddHandler Controller.ErrorsReported, AddressOf Controller_ErrorsReported
            AddHandler Controller.ConnectStatusChanged, AddressOf Controller_ConnectStatusChanged

            Controller.Subscribe(New List(Of Item.Ilmu.ObjectService.SubscriptionRequest)() From {
                New Item.Ilmu.ObjectService.SubscriptionRequest() With {
                    .ComObject = Item.Ilmu.ObjectService.ComObjectType.SPEEDACTUAL,
                    .IntervalInMS = 250,
                    .SendHistory = False
                },
                New Item.Ilmu.ObjectService.SubscriptionRequest() With {
                    .ComObject = Item.Ilmu.ObjectService.ComObjectType.TEMPMOTOR,
                    .IntervalInMS = 250,
                    .SendHistory = False
                },
                New Item.Ilmu.ObjectService.SubscriptionRequest() With {
                    .ComObject = Item.Ilmu.ObjectService.ComObjectType.CURRENTACTUAL,
                    .IntervalInMS = 250,
                    .SendHistory = False
                },
                New Item.Ilmu.ObjectService.SubscriptionRequest() With {
                    .ComObject = Item.Ilmu.ObjectService.ComObjectType.TEMPLEISTUNG,
                    .IntervalInMS = 250,
                    .SendHistory = False
                },
                New Item.Ilmu.ObjectService.SubscriptionRequest() With {
                    .ComObject = Item.Ilmu.ObjectService.ComObjectType.TORQUEACTUAL,
                    .IntervalInMS = 250,
                    .SendHistory = False
                },
                New Item.Ilmu.ObjectService.SubscriptionRequest() With {
                    .ComObject = Item.Ilmu.ObjectService.ComObjectType.TEMPKONDENSATOR,
                    .IntervalInMS = 250,
                    .SendHistory = False
                },
                New Item.Ilmu.ObjectService.SubscriptionRequest() With {
                    .ComObject = Item.Ilmu.ObjectService.ComObjectType.WIRKLEISTUNGACTUAL,
                    .IntervalInMS = 250,
                    .SendHistory = False
                },
                New Item.Ilmu.ObjectService.SubscriptionRequest() With {
                    .ComObject = Item.Ilmu.ObjectService.ComObjectType.I2TMOTOR,
                    .IntervalInMS = 250,
                    .SendHistory = False
                },
                New Item.Ilmu.ObjectService.SubscriptionRequest() With {
                    .ComObject = Item.Ilmu.ObjectService.ComObjectType.BETRIEBSART,
                    .IntervalInMS = 250,
                    .SendHistory = False
                },
                New Item.Ilmu.ObjectService.SubscriptionRequest() With {
                    .ComObject = Item.Ilmu.ObjectService.ComObjectType.VOLTZWISCHENKREIS,
                    .IntervalInMS = 250,
                    .SendHistory = False
                }
            })
        End Sub

        Private Sub Window_Closing(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs)
            Controller.Disconnect()
        End Sub

        Private Sub Controller_ErrorsReported(ByVal sender As Item.Ilmu.ObjectService.ObjectService, ByVal e As List(Of String))
            Debug.WriteLine("Errors: " & String.Join(", ", e))
        End Sub

        Private Sub Controller_RegisterChanged(ByVal sender As Item.Ilmu.ObjectService.ObjectService, ByVal register As Item.Ilmu.ObjectService.ComObjectValue)
            Select Case register.ID
                Case Item.Ilmu.ObjectService.ComObjectType.STATUSWORD
                    Dim Status As UInteger = register.GetValue(Of UInteger)()
                    LastStatusWord = Status
                Case Item.Ilmu.ObjectService.ComObjectType.TEMPMOTOR
                Case Item.Ilmu.ObjectService.ComObjectType.CURRENTACTUAL
                Case Item.Ilmu.ObjectService.ComObjectType.SPEEDACTUAL
                Case Item.Ilmu.ObjectService.ComObjectType.TEMPLEISTUNG
                Case Item.Ilmu.ObjectService.ComObjectType.WIRKLEISTUNGACTUAL
                Case Item.Ilmu.ObjectService.ComObjectType.I2TMOTOR
                Case Item.Ilmu.ObjectService.ComObjectType.VOLTZWISCHENKREIS
                Case Item.Ilmu.ObjectService.ComObjectType.POSACTUAL
            End Select
        End Sub

        Private Sub Controller_MovementStatusChanged(ByVal sender As Item.Ilmu.ObjectService.ObjectService)
            Debug.WriteLine("MoveStatus: " & sender.MovementStatus.ToString() & " | MoveMode: " + sender.MovementMode.ToString())
        End Sub

        Private Sub Controller_LogMessage(ByVal sender As Item.Ilmu.ObjectService.ObjectService, ByVal e As Item.Ilmu.ObjectService.Logger.LogMessageEventArgs)
            Debug.WriteLine(e.Message & " [" + (CType(e.ErrorCode, Item.Ilmu.ObjectService.LogErrorCodes)).ToString() & "]")
        End Sub

        Private Sub Controller_ConnectStatusChanged(ByVal sender As Item.Ilmu.ObjectService.ObjectService)
            Debug.WriteLine("Connect Status: " & sender.ComStatus.ToString())
            UpdateConnectionStatus()
        End Sub

        Private Sub Controller_Disconnected(ByVal sender As Item.Ilmu.ObjectService.ObjectService)
            Debug.WriteLine("ILMU Disconnected")
            UpdateConnectionStatus()
        End Sub

        Private Sub Controller_Connected(ByVal sender As Item.Ilmu.ObjectService.ObjectService)
            Debug.WriteLine("ILMU Connected")
            UpdateConnectionStatus()
        End Sub

        Private Async Sub ButtonConnect_Click(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Await Controller.ConnectAsync(Item.Ilmu.ObjectService.ComDeviceType.AUTO, "192.168.0.82", 8802, "AUTO", 0)
        End Sub

        Private Async Sub ButtonDisconnect_Click(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Await Controller.DisconnectAsync()
        End Sub

        Private Async Sub ButtonMove_Click(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim Position As Double = 0
            Dim Speed As Double = 50
            Dim Acceleration As Double = 3000
            Dim TorqueLimit As Double = 0.8
            Dim HasTorqueLimit As Boolean = (CheckboxTorqueLimited.IsChecked = True)

            Try
                Position = Double.Parse(TextboxPosition.Text.Replace(","c, "."c), System.Globalization.CultureInfo.InvariantCulture)
            Catch __unusedException1__ As Exception
            End Try

            Try
                Speed = Double.Parse(TextboxSpeed.Text.Replace(","c, "."c), System.Globalization.CultureInfo.InvariantCulture)
            Catch __unusedException1__ As Exception
            End Try

            Try
                Acceleration = Double.Parse(TextboxAcceleration.Text.Replace(","c, "."c), System.Globalization.CultureInfo.InvariantCulture)
            Catch __unusedException1__ As Exception
            End Try

            Try
                TorqueLimit = Double.Parse(TextboxLimit.Text.Replace(","c, "."c), System.Globalization.CultureInfo.InvariantCulture)
            Catch __unusedException1__ As Exception
            End Try

            Dim SoftwareEndswitchMaximum As Double = Await Controller.GetComObjectValueAsync(Of Double)(Item.Ilmu.ObjectService.ComObjectType.SWENDSWITCHMAXIMUMH)
            Dim SoftwareEndswitchMinimum As Double = Await Controller.GetComObjectValueAsync(Of Double)(Item.Ilmu.ObjectService.ComObjectType.SWENDSWITCHMINIMUMH)
            Position = Math.Min(SoftwareEndswitchMaximum - 0.5, Math.Max(SoftwareEndswitchMinimum + 0.5, Position))
            Dim f As Item.Ilmu.ObjectService.LogErrorCodes

            If HasTorqueLimit Then
                f = Await MovementMethod1_ManualWithTorqueLimit(Position, Speed, Acceleration, TorqueLimit)
            Else
                f = Await MovementMethod2_AutomaticPositioning(Position, Speed, Acceleration)
            End If

            Debug.WriteLine("Movement Result: " & f.ToString())
        End Sub

        Private Async Function MovementMethod1_ManualWithTorqueLimit(ByVal Position As Double, ByVal Speed As Double, ByVal Acceleration As Double, ByVal TorqueLimit As Double) As System.Threading.Tasks.Task(Of Item.Ilmu.ObjectService.LogErrorCodes)
            Dim ControlWord2 As Item.Ilmu.ObjectService.PositionControlword2 = CType(Await Controller.GetComObjectValueAsync(Of Double)(Item.Ilmu.ObjectService.ComObjectType.POSITIONPOINTER, 0, Item.Ilmu.ObjectService.ComObjectType.POSITIONCONTROLWORD2), Item.Ilmu.ObjectService.PositionControlword2)
            ControlWord2 = ControlWord2 Or Item.Ilmu.ObjectService.PositionControlword2.TargetReachedCriteria1
            ControlWord2 = ControlWord2 And Not (Item.Ilmu.ObjectService.PositionControlword2.TargetReachedCriteria2 Or Item.Ilmu.ObjectService.PositionControlword2.TargetReachedCriteria3)
            Dim ControlWord As Item.Ilmu.ObjectService.PositionControlword = (Item.Ilmu.ObjectService.PositionControlword.StartWPPositioningMode1 Or Item.Ilmu.ObjectService.PositionControlword.StartWPPositioningMode2 Or Item.Ilmu.ObjectService.PositionControlword.StartWPPositioningMode3)
            Await Controller.WritePositionDataAsync(0, New Item.Ilmu.ObjectService.PositionInfo() With {
                .Endpos = Position,
                .Accel = Acceleration,
                .Decel = Acceleration,
                .Speed = Speed,
                .Controlword2 = ControlWord2,
                .TorqueThreshold = TorqueLimit,
                .Successor = 1,
                .Controlword = ControlWord
            })
            Await Controller.WritePositionDataAsync(1, New Item.Ilmu.ObjectService.PositionInfo() With {
                .Endpos = 0,
                .Accel = Acceleration,
                .Decel = Acceleration,
                .Speed = Speed * 2,
                .Controlword2 = ControlWord2,
                .TorqueThreshold = TorqueLimit,
                .Successor = 0,
                .Controlword = 0
            })
            Dim f As Item.Ilmu.ObjectService.LogErrorCodes = Await Controller.SendMovementCommandToControllerAsync(Item.Ilmu.ObjectService.MovementMode.MoveToWaypoint, 0)
            Return f
        End Function

        Private Async Function MovementMethod2_AutomaticPositioning(ByVal Position As Double, ByVal Speed As Double, ByVal Acceleration As Double) As System.Threading.Tasks.Task(Of Item.Ilmu.ObjectService.LogErrorCodes)
            Return Await Controller.SendMovementCommandToControllerAsync(Item.Ilmu.ObjectService.MovementMode.MoveToPosition, Position, Speed, Acceleration)
        End Function

        Private Async Sub ButtonEnable_Click(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Await Controller.ClearWarningsAndErrorsAsync()
            Await Controller.SetClearanceSelectorAsync(Item.Ilmu.ObjectService.ReglerFreigabeSelector.DIN5AndPC)
            Dim [error] = Await Controller.SendDeviceCommandToControllerAsync(Item.Ilmu.ObjectService.IlmuCmd.EnableController)

            If [error] = Item.Ilmu.ObjectService.LogErrorCodes.CommandTimeout Then
                Debug.WriteLine("Controller can not be enabled. Check if Din4 + Din5 are set up properly.")
            End If
        End Sub

        Private Async Sub ButtonDisable_Click(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Await Controller.SendDeviceCommandToControllerAsync(Item.Ilmu.ObjectService.IlmuCmd.DisableController)
        End Sub

        Private Async Sub ButtonReference_Click(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Await Controller.StartReferencingAsync(Item.Ilmu.ObjectService.ReferenceDirection.CURRENTLY_SET)
        End Sub

        Private Async Sub ButtonStop_Click(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Await Controller.SendMovementStopToControllerAsync()
        End Sub

        Private Sub UpdateConnectionStatus()
            If Not Dispatcher.CheckAccess() Then
                Dispatcher.Invoke(Sub()
                                      UpdateConnectionStatus()
                                  End Sub)
                Return
            End If

            If Controller IsNot Nothing AndAlso Controller.IsConnected Then
                ButtonConnect.Background = New SolidColorBrush(Color.FromRgb(0, 255, 0))
            Else
                ButtonConnect.Background = New SolidColorBrush(Color.FromRgb(255, 0, 0))
            End If
        End Sub
    End Class
End Namespace
